// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                ST STA2051 Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates an interrupt handler and setting up a timer.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ST2051.h>

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

static int count;

#define IVECT 19
#define SIR(n) (*(&SIR0 + n))

void
irq_handler(void)
{
  unsigned long ivr = IVR;
  count++;
  EFT1_SR = ~EFT1_SR; /* Clear timer status register */
  IPR0 = 1 << CICR; /* EOI */
}

int
main(void)
{
  int i;
  __ARMLIB_enableIRQ();
  ICR = 0; // Global IRQ output disabled
  IER0 = 0; // Disable interrupts
  IPR0 = 0xFFFFFFFF; // Clear all pending interrupts.

  IVR = 0;
  ICR = 1; // Global IRQ output enabled
  SIR(IVECT) =  1; // Set up priority
  IER0 = 1 << IVECT; // Enable interrupt channel

  EFT1_SR = 0; // Clear timer status register
  EFT1_CNTR = 0; // Reset the counter to 0xFFFC
  EFT1_CR2 = 32; // Set the prescaler
 
  EFT1_OCAR = 0xFFFF; // stop OCF1 being set when TOF is set
  EFT1_OCBR = 0xFFFF; // stop OCF2 being set when TOF is set

  EFT1_SR = 0; // Clear timer status register
  EFT1_CR2 |= 1 << 13; // Enable timer overflow interrupt
  EFT1_CR1 = 1 << 15; // Enable the timer

  while(count < 75);

  while(1);
    
  return 0; 
}
