// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/ST2051.h>

#define TIMER0_INT 4

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  unsigned int x;
  userTimerISR();
  /* Clear the timer interrupt */
  EFT1_SR = ~EFT1_SR;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  EFT1_SR = 0; /* Clear timer status register */
  EFT1_CNTR = 0; /* Reset the counter to 0xFFFC */
  EFT1_CR2 = 0; /* Set the prescaler */
 
  EFT1_OCAR = 0xFFFF; /* stop OCF1 being set when TOF is set */
  EFT1_OCBR = 0xFFFF; /* stop OCF2 being set when TOF is set */

  EFT1_SR = 0; /* Clear timer status register */
  EFT1_CR2 |= (1 << 13); /* Enable timer overflow interrupt */
  EFT1_CR1 = 1 << 15; /* Enable the timer */

  userTimerISR = isr;
  ctl_set_isr(19, 1, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(19);
}

void
Idle(void)
{
  ++idleCount;
}
