/*===============================< system.h >============================*/

// Musical note frequencies
#define A3	220
#define B3	247
#define C4	261
#define D4  294
#define E4  330
#define F4	349
#define G4	392
#define A4	440
#define B4  494
#define C5  523
#define D5  587

/*============================< Unit Prototypes >========================*/

/*--------------------------------< SysInit >----------------------------*/
// Initializes Uart0 as communications channel to keyboard controller.
// Also configures PWM1 for sound, but does not enable it.
// Parameters 	:	none
// Returns		:	nothing
void SysInit(void);

/*---------------------------------< getch >-----------------------------*/
// Gets a keypress from the keyboard.  This function will wait for a 
// valid keypress.
// Parameters	:  none
// Returns :		ASCII code of key pressed.
BYTE getch(void);

/*--------------------------------< KbGets >-----------------------------*/
// Get and entire string from the keyboard.  Looks for CR or MaxLen and
// then NULL terminates the string.
// Parameters	:	pStr		Pointer to buffer to store string
//						wMaxLen	Max length of string to accept
// Returns :		Length of string (including Null).
WORD KbGets(PSTR pStr, WORD wMaxLen);

/*--------------------------------< KbScan >-----------------------------*/
// Gets the Scan Code (Set II) from the most recent keypress. Helpful for
// testing the keyboard driver (especially extended keyset).
// Parameters	:	none
// Returns :		Scan code for most recent keypress
BYTE KbScan(void);

/*--------------------------------< KbLeds >-----------------------------*/
// Controls the keyboard Scroll, Num and Capslock LEDs (Bits 0-2). 
// Bits 3-7 are unused and must be 0.
// Parameters :	bLed 		LED Bit pattern 
// Returns : 		nothing
void KbLeds(BYTE bLed);

/*---------------------------< SysGetVersion >---------------------------*/
// Gets system version information previously read from keyboard controller.
// Parameters : 	none
// Returns :		Version info (xxxxxx10 HEX = 1.0) xx = unused
WORD SysGetVersion(void);

/*-------------------------------< SoundOn >-----------------------------*/
// Initiates a tone at a particular frequency.
// Parameters :	wFreq		Frequency of tone - useful range (100-10kHz?)
// Returns :		nothing
void SoundOn(WORD wFreq);

/*------------------------------< SoundOff >-----------------------------*/
// Stops a tone.
// Parameters : 	none
// Returns	:		nothing
void SoundOff(void);

/*------------------------------< SysDelay >-----------------------------*/
// Delays for specified duration in ms.  Uses RTC counter.
// Parameters : 	wDur	Duration in milli-seconds.
// Returns :		nothing
void SysDelay(WORD wDur);

// end of system.h
