/*================================< string.c >===============================*/
// 
//    Title:      STRING FUNCTIONS
//    Saved date: 28 Jun 2003 11:34:47
//    Written by: JAG
//    Project:    RMS101 SBC
//    Target:     LH79520
//    Compiler:   GNU GCC for ARM
//		Copyright:	Subject to the Revely Open Source License (see readme.txt)
//
// Compact string creation and manipulation functions.  This unit has a few
// simple functions that can sometimes eliminate the bloated functions in 
// libc.a
// 
// V1.00 	27/07/02 JAG Initial release
//
/*===========================================================================*/

#include <stddefs.h>
#include <rstring.h>

/*-------------------------------< StrToUpper >------------------------------*/
void StrToUpper(char *string)
{
	char *pS;
	
	pS = string;
	while (*pS)
	{
		*pS = toupper(*pS);
		pS++;
	}
}

/*-------------------------------< SprintWord >------------------------------*/
void SprintWord(char *str, HALF wVal, int bWidth)
{
   int bDigNum, i=0;
     
   for (bDigNum=5; bDigNum>0; bDigNum--)
   {
      switch (bDigNum)
      {
      	case 5:  str[i] = (char)(wVal/10000)+0x30;
                  wVal %= 10000;
                  break;
         case 4:  str[i] = (char)(wVal/1000)+0x30;
                  wVal %= 1000; 
                  break;
         case 3:  str[i] = (char)(wVal/100)+0x30;
                  wVal %= 100;
                  break;
         case 2:  str[i] = (char)(wVal/10)+0x30;
                  wVal %= 10;
                  break;
         case 1:  str[i] = (char)wVal+0x30;
      }      
      if (bDigNum <= bWidth)
         i++;
   }   
   str[i] = 0;	// add null
}

/*--------------------------------< SprintHex >-------------------------------*/
void SprintHex(char *str, WORD wVal, int bWidth)
{
   int bDigNum, i=0;
   
   for (bDigNum=6; bDigNum>0; bDigNum--)
   {
      switch (bDigNum) 
      {
      	case 6:  str[i] = (char)(wVal/1048576)+0x30;
                  wVal %= 1048576; 
                  break;
      	case 5:  str[i] = (char)(wVal/65536)+0x30;
                  wVal %= 65536; 
                  break;
         case 4:  str[i] = (char)(wVal/4096)+0x30;
                  wVal %= 4096; 
                  break;
         case 3:  str[i] = (char)(wVal/256)+0x30;
                  wVal %= 256;
                  break;
         case 2:  str[i] = (char)(wVal/16)+0x30;
                  wVal %= 16;
                  break;
         case 1:  str[i] = (char)wVal+0x30;
      }      
      if (str[i] > '9')
      	str[i] += 7;		// alpha offset
      if (bDigNum <= bWidth)
         i++;
   }   
   str[i] = 0;	// add null
}

/*-------------------------------< AsciiToInt >-------------------------------*/
WORD AsciiToInt(BYTE bBytes, PBYTE pData)
{
   WORD dNum=0, dDigit;

   while (bBytes > 0)
   {
      if (bBytes == 6) 
         dDigit = 1048576;
      if (bBytes == 5)
         dDigit = 65536;
      if (bBytes == 4)
         dDigit = 4096;
      if (bBytes == 3)
         dDigit = 256;
      if (bBytes == 2)
         dDigit = 16;
      if (bBytes == 1)
         dDigit = 1;
      if ((*pData > 0x2f) && (*pData < 0x3a))         // is it numeric ?
         dNum += (((WORD) (*pData++ - 0x30)) * dDigit);  
      else
         dNum += (((WORD) (*pData++ - 55)) * dDigit);  // must be alpha
      bBytes--;
   }
   return dNum;
} 

// end of string.c
