// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                 Revely RMS100 Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler. When running, pressing
// the "Mode" button causes the irq_handler to execute which toggles
// the LEDs.
//
////////////////////////////////////////////////////////////////////////////////

#include "__armlib.h"
#include <targets/LH754xx.h>
                                             
#define EXTERNAL_INTERRUPT_5_INT 12

static void
initLED()
{
  GPIO_PCDDR = 0xC0; 
  GPIO_PCDR &= ~0xC0;
}

static void
toggleLED()
{      
  GPIO_PCDR ^= 0xC0;
}                 

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  toggleLED();
  RCPC_IntClear = 1 << 5;
}
          
int
main(int argc, const char *argv[])
{
  unsigned int v;

  initLED();  

  /* Clear interrupt */
  RCPC_IntClear = 1 << 5;

  /* Configure Pin PD5/INT5/DACK to INT5 */
  IOCON_PD_MUX &= ~(3 << 7);
  IOCON_PD_MUX |= 1 << 7;

  /* Enable Pull-up resistor on INT5 */
  IOCON_PD_RES_MUX &= ~(3 << 10);
  IOCON_PD_RES_MUX |= 1 << 10;

  /* Falling edge trigger */
  RCPC_IntConfig &= ~3 << 10;
  RCPC_IntConfig |= 2 << 10;

  /* External interrupt 5 is an IRQ interrupt */
  VIC_IntSelect &= ~(1 << EXTERNAL_INTERRUPT_5_INT);
  /* Enable External interrupt 5 */
  VIC_IntEnable = 1 << EXTERNAL_INTERRUPT_5_INT;

  __ARMLIB_enableIRQ();

  while(1)
    v++;
  
  return 0;
}
