// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                      Olimex LPC-P1  LED Example
//
// Description
// -----------
// This example demonstrates writing to the programmable peripheral interface.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LPC210x.h>

static void
ledInit()
{
  IODIR |= 0x00000080;
  IOSET = 0x00000080;
}

static void
ledOn(void)
{
  IOCLR = 0x00000080;
}

static void
ledOff(void)
{
  IOSET = 0x00000080;
}

void
delay(int d)
{     
  for(; d; --d);
}
 
int
main(void)
{
  MAMCR = 2;
  ledInit();
  while (1)
    {
      ledOn();
      delay(100000);
      ledOff();
      delay(100000);
    }
  return 0;
}


