// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// Test interruptible ISRs (NOTE: Requires timer to have higher priority than button)

#include "test.h"
#include <assert.h>
#include <ctl_api.h>

CTL_TASK_t mainTask, otherTask;
unsigned otherStack[64];
unsigned e1=0;
unsigned timerCount = 0;
unsigned buttonPressedCount = 0;

#define TIMER_EVENT (1<<0)

static int inButtonPressedISR;
static int inTimerISR;

void 
buttonPressedISR(void)
{
  /* Check buttonPressedISR doesn't re-enter */
  assert(!inButtonPressedISR);
  /* Check that timer interrupt hasn't been interrupted */
  assert(!inTimerISR);
  /* Signal that buttonPressedISR is executing */
  inButtonPressedISR = 1;
  /* Reset timer counter */
  timerCount = 0;
  /* Re-enable interrupts */
  ctl_isr_enable_interrupts();
  /* Wait for timer interrupt to trigger */
  while (timerCount == 0);
  ++buttonPressedCount;
  /* Disable interrupts */
  ctl_isr_disable_interrupts();
  /* Signal that buttonPressedISR is no longer executing */
  inButtonPressedISR = 0;
}

void
timerISR(void)
{
  /* Check that timerISR doesn't re-enter */
  assert(!inTimerISR);
  /* Signal that timerISR is executing */
  inTimerISR = 1;
  /* Set timer event only if timerISR has interrupted buttonPressedISR */
  if (inButtonPressedISR)
    ctl_set_clear_events(&e1, TIMER_EVENT, 0);
  ++timerCount;
  /* Signal that timerISR is no longer executing */
  inTimerISR = 0;
}

void 
other(void *p)
{
  unsigned leds = 0;
  while (1)
    {
      unsigned w=ctl_task_wait(CTL_STATE_EVENT_WAIT|CTL_STATE_EVENT_ANY_NOT_ALL, 0, &e1, TIMER_EVENT);
      if (w & TIMER_EVENT)
        {
          ctl_set_clear_events(&e1, 0, TIMER_EVENT);
          SetLeds(leds);
          leds ^= 0xFFFFFFFF;
        }
        else
          ; // error case
    }
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

void
__assert(const char *expr, const char *file, int line)
{
  while (1);
}

int main(void)
{
  unsigned int v=0;
  BoardInit();
  ctl_task_init(&mainTask, 0, "main");  
  ctl_task_run(&otherTask, 1, other, 0, "other", sizeof(otherStack)/sizeof(unsigned), otherStack);
  SetTimerISR(timerISR);
  SetButtonPressedISR(buttonPressedISR);
  while (1)
    Idle();
  return 0;
}
