// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                  OKI M674000 Evaluator Interrupt Example
//
// Description
// -----------
// This example demonstrates the setting up of IRQ and FIQ handlers. Press
// the IRQ0 and FIRQ buttons to raise the interrupts.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ML674000.h>

#define LED (*(volatile unsigned char *)0xF0000000)

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));
void fiq_handler(void) __attribute__ ((interrupt ("FIQ")));

static unsigned char ledval;

void
irq_handler(void)
{
  unsigned int irn = IRN;
  unsigned int cil = CIL;
  if (irn == 28)
    {
      ledval ^= 0x06;
      LED = ledval;
      IRQA = 0x0000;
    }
  IRCL = irn;
  CILCL = 1;
}

void
fiq_handler(void)
{
  ledval ^= 0x30;
  LED = ledval;
}

void
delay(unsigned n)
{
  while (n--);
}

void
enableInterrupts()
{
  __ARMLIB_enableIRQ();
  __ARMLIB_enableFIQ();
}

void
disableInterrupts()
{
  __ARMLIB_disableIRQ();
  __ARMLIB_disableFIQ();
}

int
main(void)
{
  enableInterrupts();
  ILC = 0x01000000; // Enable IR28 (low priority)
  IDM = 0x00001000; // Falling edge
  FIQEN = 1; // Enable FIQ interrupts

  while(1)
    {
      disableInterrupts();
      ledval ^= 0x80;
      enableInterrupts();
      LED = ledval;
      delay(100000);
    }

  return 0;
}

