// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/AX07CF192.h>

#define PROCESSOR_CLOCK_FREQUENCY 33000000

void
BoardInit(void)
{
  /* Set P75 to output */
  P7DDR &= ~(1 << 5);
}

unsigned long
TicksPerSecond(void)
{
  return PROCESSOR_CLOCK_FREQUENCY / 2 / 0x10000;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  ctl_set_isr(0, 0, CTL_ISR_TRIGGER_POSITIVE_EDGE, buttonISR, 0);
  ctl_unmask_isr(0);
}

void
SetLeds(unsigned v)
{
  if (v)
    P7DR &= ~(1 << 5);
  else
    P7DR |= 1 << 5;
}

