// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                         Atmel EB01 LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AT91x408xx.h>

#define LED1 (1 << 1)
#define LED2 (1 << 4)
#define LED3 (1 << 2)
#define LEDS (LED1 | LED2 | LED3)

int delay(int);

void ledInit()
{
  PIO_PER = LEDS;
  PIO_OER = LEDS;
}

void ledOff(int led)
{
  PIO_SODR = led;
}

void ledOn(int led)
{
  PIO_CODR = led;
}

#define NUM_LEDS 3

int leds[] = { LED1, LED2, LED3 };

int
main(void)
{
  int i, j;
  ledInit();
  while (1)
    {
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOn(leds[i]);
          delay(100000);
        }
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOff(leds[i]);
          delay(100000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOn(leds[i]);
          delay(100000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOff(leds[i]);
          delay(100000);
        }
    }
  return 0;
}
