/*    Copyright (C) 2010-2020 Free Software Foundation, Inc.
 *       Written by Rowley Associates Limited.
 *
 *       This program is free software; you can redistribute it and/or modify it
 *       under the terms of the GNU General Public License as published by the
 *       Free Software Foundation; either version 2, or (at your option) any
 *       later version.
 *
 *       This program is distributed in the hope that it will be useful,
 *       but WITHOUT ANY WARRANTY; without even the implied warranty of
 *       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *       GNU General Public License for more details.
 *
 *       You should have received a copy of the GNU General Public License
 *       along with this program; if not, write to the Free Software
 *       Foundation, 51 Franklin Street - Fifth Floor,
 *       Boston, MA 02110-1301, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#if defined(WIN32)
#include <io.h>
#elif defined(UNIX)
#include <unistd.h>
#endif
#include "simple-object.h"
#ifndef O_BINARY
#define O_BINARY 0
#endif

extern "C" char *
xstrdup (const char *s)
{
  size_t len = strlen (s) + 1;
  char *ret = (char *) malloc (len);
  return (char *) memcpy (ret, s, len);
}

extern "C" void *
xmalloc(size_t s)
{
  return malloc(s);
}

extern "C" void *
xrealloc(void *p, size_t s)
{
  return realloc(p, s);
}

extern "C" void *
xcalloc(size_t n, size_t s)
{
  return calloc(n, s);
} 

extern "C"
{
#include "simple-object-common.h"
const struct simple_object_functions simple_object_coff_functions = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const struct simple_object_functions simple_object_mach_o_functions = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const struct simple_object_functions simple_object_xcoff_functions = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
}

int
main(int argc, char **argv)
{
  if (argc != 3)
    {
      printf("usage: %s infile outfile\n",argv[0]);
      exit(EXIT_FAILURE);
    }
  const char *infile = argv[1];
  const char *outfile = argv[2];
  int infd = open (infile, O_RDONLY | O_BINARY);
  if (infd == -1)
    {
      fprintf(stderr, "failed to open %s\n", infile);
      exit(EXIT_FAILURE);
    }
  int inoff = 0;
  const char *errmsg;
  int err;
  simple_object_read *inobj = simple_object_start_read (infd, inoff,
							"__GNU_LTO",
							&errmsg, &err);
  if (!inobj)
    {
      fprintf(stderr, "failed to simple_object_start_read %s\n", errmsg);
      exit(EXIT_FAILURE);
    }

  off_t off, len;
  if (simple_object_find_section (inobj, ".gnu.debuglto_.debug_info",
				  &off, &len, &errmsg, &err) != 1)
    {
      fprintf(stderr, "failed to simple_object_find_section %s\n", errmsg);
      exit(EXIT_FAILURE);
    }

  errmsg = simple_object_copy_lto_debug_sections (inobj, outfile, &err, 1);
  if (errmsg)
    {
      fprintf(stderr, "failed to simple_object_copy_lto_debug_sections %s\n", errmsg);
      exit(EXIT_FAILURE);
    }

  simple_object_release_read (inobj);
  close (infd);

  return EXIT_SUCCESS;
}


